VERSION 5.00
Object = "{3B7C8863-D78F-101B-B9B5-04021C009402}#1.2#0"; "RichTx32.ocx"
Begin VB.Form frmMain 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "RichTextBox Background Colours Example"
   ClientHeight    =   5070
   ClientLeft      =   45
   ClientTop       =   330
   ClientWidth     =   7260
   BeginProperty Font 
      Name            =   "Tahoma"
      Size            =   8.25
      Charset         =   0
      Weight          =   400
      Underline       =   0   'False
      Italic          =   0   'False
      Strikethrough   =   0   'False
   EndProperty
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   5070
   ScaleWidth      =   7260
   StartUpPosition =   2  'CenterScreen
   Begin VB.CommandButton cmdSetColour 
      Caption         =   "Reset"
      Height          =   315
      Index           =   6
      Left            =   6240
      TabIndex        =   14
      Top             =   3420
      Width           =   915
   End
   Begin VB.CommandButton cmdSetColour 
      Caption         =   "White"
      Height          =   315
      Index           =   5
      Left            =   5220
      TabIndex        =   7
      Top             =   3420
      Width           =   915
   End
   Begin VB.CommandButton cmdSetColour 
      Caption         =   "Black"
      Height          =   315
      Index           =   4
      Left            =   4200
      TabIndex        =   6
      Top             =   3420
      Width           =   915
   End
   Begin VB.CommandButton cmdSetColour 
      Caption         =   "Cyan"
      Height          =   315
      Index           =   3
      Left            =   3120
      TabIndex        =   5
      Top             =   3420
      Width           =   915
   End
   Begin VB.CommandButton cmdSetColour 
      Caption         =   "Green"
      Height          =   315
      Index           =   2
      Left            =   2100
      TabIndex        =   4
      Top             =   3420
      Width           =   915
   End
   Begin VB.CommandButton cmdSetColour 
      Caption         =   "Yellow"
      Height          =   315
      Index           =   1
      Left            =   1080
      TabIndex        =   3
      Top             =   3420
      Width           =   915
   End
   Begin VB.CommandButton cmdSetColour 
      Caption         =   "Red"
      Height          =   315
      Index           =   0
      Left            =   60
      TabIndex        =   1
      Top             =   3420
      Width           =   915
   End
   Begin RichTextLib.RichTextBox RichTextBox 
      Height          =   2715
      Left            =   60
      TabIndex        =   0
      Top             =   660
      Width           =   7095
      _ExtentX        =   12515
      _ExtentY        =   4789
      _Version        =   393217
      TextRTF         =   $"frmMain.frx":0000
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "Tahoma"
         Size            =   14.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
   End
   Begin VB.Label lblAbout 
      Alignment       =   2  'Center
      Caption         =   "#"
      Height          =   435
      Left            =   60
      TabIndex        =   15
      Top             =   4560
      Width           =   2835
   End
   Begin VB.Label lblHex 
      Caption         =   "- Hex colour: #"
      Height          =   195
      Left            =   3420
      TabIndex        =   13
      Top             =   4500
      Width           =   2775
   End
   Begin VB.Label lblOLE 
      Caption         =   "- OLE (long) colour: #"
      Height          =   195
      Left            =   3420
      TabIndex        =   12
      Top             =   4260
      Width           =   2475
   End
   Begin VB.Label lblText 
      Caption         =   "The text highlighted (or under the caret):"
      BeginProperty Font 
         Name            =   "Tahoma"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   195
      Left            =   3240
      TabIndex        =   11
      Top             =   3960
      Width           =   3615
   End
   Begin VB.Label lblColourG 
      Caption         =   "G: #"
      Height          =   255
      Left            =   6480
      TabIndex        =   10
      Top             =   4500
      Width           =   615
   End
   Begin VB.Label lblColourB 
      Caption         =   "B: #"
      Height          =   255
      Left            =   6480
      TabIndex        =   9
      Top             =   4740
      Width           =   615
   End
   Begin VB.Label lblColourR 
      Caption         =   "R: #"
      Height          =   255
      Left            =   6480
      TabIndex        =   8
      Top             =   4260
      Width           =   615
   End
   Begin VB.Label lblHelp 
      Alignment       =   2  'Center
      Caption         =   "#"
      Height          =   495
      Left            =   120
      TabIndex        =   2
      Top             =   120
      Width           =   7035
   End
End
Attribute VB_Name = "frmMain"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private Sub cmdSetColour_Click(Index As Integer)

    ' The second variable for SetSelFontBackColor is the type OLE_COLOR,
    ' and can therefore be any VB colour constant (vbBlack, etc) or
    ' any LONG that represents an RGB colour, so use the RGB() function.
    
    ' All of these are demonstrated.
    
    ' Sending an OLE_COLOR of -1 resets the FontBackColour to whatever the
    ' controls BackColour is.

    Select Case Index
        Case 0:
            Call SetSelBackColor(RichTextBox.hwnd, vbRed)
        Case 1:
            Call SetSelBackColor(RichTextBox.hwnd, vbYellow)
        Case 2:
            Call SetSelBackColor(RichTextBox.hwnd, vbGreen)
        Case 3:
            Call SetSelBackColor(RichTextBox.hwnd, vbCyan)
        Case 4:
            Call SetSelBackColor(RichTextBox.hwnd, RGB(0, 0, 0))
        Case 5:
            Call SetSelBackColor(RichTextBox.hwnd, RGB(255, 255, 255))
        Case 6:
            Call SetSelBackColor(RichTextBox.hwnd, -1)
    End Select
    
    ' Set the focus back to the RichTextBox control
    RichTextBox.SetFocus
    
    ' And get info on the newly updated colour
    GetBackgroundInfo
End Sub

Private Sub Form_Load()
    lblAbout.Caption = "Coded by davidc" & vbCrLf & "http://edeca.net/"
    lblHelp.Caption = "Select some text and choose a back colour by clicking the appropriate button." & vbCrLf & "Info on the current background colour is given for the colour underneath the caret."
    
    ' We don't want hash symbols floating about all over
    ' the place where there's supposed to be values.. so
    ' update immediately.
    GetBackgroundInfo
End Sub

Private Sub RichTextBox_Click()
    ' Get info on the colour under the cursor
    GetBackgroundInfo
End Sub

Private Sub GetBackgroundInfo()
    Dim myColour As Long
    Dim R, G, B
    Dim HexColour As String
    Dim Index As Integer
    
    ' Get the colour into the variable and update the
    ' label.
    myColour = GetSelBackColor(RichTextBox.hwnd)
    lblOLE.Caption = "- OLE (long) colour: " & myColour
    
    ' Convert the OLE long colour to hex
    HexColour = Hex(myColour)
    ' If it's less than 6 characters, pad with
    ' zeroes
    For Index = 1 To (6 - Len(HexColour))
        HexColour = HexColour & "0"
    Next Index
    
    ' Update the hex label
    lblHex.Caption = "- Hexadecimal colour: #" & HexColour
    
    ' Get the individual RGB parts into variables
    ' R, G, B and update labels accordingly.
    Call GetRGB(myColour, R, G, B)
    lblColourR.Caption = "R: " & R
    lblColourG.Caption = "G: " & G
    lblColourB.Caption = "B: " & B
End Sub

