#include <xc.h>
#include <stdio.h>
#include "config.h"
#include "serial.h"

void do_measure() {
    float vdd_float = 0;
    unsigned int ref = 0;
    unsigned int vdd_int = 0;

    ADCON2bits.ADFM = 1;        // Right justify result
    ADCON0bits.GO = 1;
    while (!ADCON0bits.DONE);

    ref = ADRESH << 8;
    ref |= ADRESL;
    
    // Fixed point math only
    vdd_int = 8192 / ref;
    vdd_int *= 1024;
    vdd_int /= 8;

    // Floating point
    vdd_float = 1024.0 / ref;
    vdd_float *= 1.024;

    printf("Result: raw %u, vdd_float %0.2fV, vdd_int %u\r\n", ref, vdd_float, vdd_int);
}

void main() {
    // All digital IO, outputs
    TRISA = 0x00;
    TRISB = 0x00;
    TRISC = 0x00;
    
    // Internal 16Mhz oscillator
    IRCF2 = 1;
    IRCF1 = 1;
    IRCF0 = 1;

    // Wait for clock to be stable
#ifndef SIMULATOR
    while (!IOFS);
#endif

    init_comms();

    LATA0 = 1;
    unsigned int x = 0;

    VREFCON0bits.FVRS = 0b01;   // Internal 1.024v ref
    FVREN = 1;                  // Enable FVR module
    while(!FVRST);              // Wait for FVR to be stable

    ADCON2bits.ADFM = 1;        // Right justify result
    ADCON0bits.CHS = 0b11111;   // FVR is ADC input
    ADCON1bits.PVCFG = 0b00;    // Positive ref is Vdd (default)
    ADCON1bits.NVCFG = 0b00;    // Negative ref is GND (default)
    ADCON0bits.ADON = 1;        // Turn on ADC module
    
    while(1) {
        LATA0 ^= 1;
        do_measure();
        for (unsigned char n = 0; n < 20; n++)
            while(x--);
    }
}