#include <xc.h>
#include <stdio.h>
#include "serial.h"

/* Serial initialization */
void 
init_comms(void)
{
	SPBRG1 = DIVIDER;     	
	TXSTA1 = (SPEED|NINE_BITS|0x20);
	RCSTA1 = (NINE_BITS|0x90);
	TRISC6 = OUTPUT;
	TRISC7 = INPUT;
}

void 
putch(unsigned char byte) 
{
	/* output one byte */
	while(!TRMT1)	/* set whilst TX in progress */
		continue;
	TXREG1 = byte;
}

unsigned char 
getch() {
	/* retrieve one byte */
	while(!RCIF)	/* set when register is not empty */
		continue;
	return RCREG;	
}

unsigned char
getche(void)
{
	unsigned char c;
	putch(c = getch());
	return c;
}

